#!/usr/bin/python

# Schema parser for checking zero-file for IBM Spectrum Archive LE

# Usage:   zero-check-le.py [pathname of index cache directory]
# Example: ./zero-check-le.py /var/lib/ltfs/<library serial number>/volume_cache

import os
import sys
# import fcntl
import xml.sax
import xml.sax.handler
import json
import subprocess
import tempfile

class Executer:
    def __init__(self, command):
        self.command = command

    def capture_long(self):
        temp = tempfile.TemporaryFile()
        temp_e = tempfile.TemporaryFile()
        try:
            p = subprocess.Popen(self.command, stdout=temp, stderr=temp_e)
        except OSError as e:
            return -1, "", str(e)

        p.wait()
        temp.seek(0)
        temp_e.seek(0)
        out = temp.read()
        err = temp_e.read()

        return p.returncode, out, err

class Handler(xml.sax.handler.ContentHandler):
    def __init__(self, barcode):
        self.barcode = barcode
        self.in_dirs = 0

        self.in_dir = False
        self.dname = ''

        self.in_file = False

        self.in_name = False
        self.fname = ''

        self.in_len = False
        self.length = '-1'

        self.in_cr = False
        self.created = ''

        self.symlink = False

        self.zero_files = 0

    def __del__(self):
        if self.zero_files:
            print('{}: {}'.format(self.barcode, self.zero_files))

    def startElement(self, name, attrs):
        if name == 'directory':
            self.in_dirs = self.in_dirs + 1
            self.in_dir = True
        elif name == 'file':
            self.in_file = True
        elif name == 'name':
            self.in_name = True
        elif name == 'length':
            self.in_len = True
        elif name == 'creationtime':
            self.in_cr = True
        elif name == 'symlink':
            self.symlink = True

    def endElement(self, name):
        if name == 'directory':
            self.in_dirs = self.in_dirs - 1
        elif name == 'file':
            self.in_file = False
        elif name == 'name':
            self.in_name = False
        elif name == 'length':
            self.in_len = False
        elif name == 'creationtime':
            self.in_cr = False

        if (not self.in_file) and len(self.fname) > 0 :
            if self.length == '0' and not self.symlink:
                self.zero_files += 1

        if not self.in_file:
            self.fname = ''
            self.length = '-1'
            self.created = ''
            self.symlink = False

    def characters(self, content):
        if self.in_dir and self.in_name:
            self.dname = content
            self.in_dir = False

        if self.in_file and self.in_name:
            self.fname = self.fname + content
        elif self.in_file and self.in_len:
            if self.length == '-1':
                self.length = content
            else:
                self.length = self.length + content
        elif self.in_file and self.in_cr:
            self.created = self.created + content

        return


def main():
    # Create a target directory list
    targets = sys.argv
    targets.pop(0)

    print('========')
    print('Tapes contains 0-byte files')
    for t in targets:
        for curdir, dirs, files in os.walk(t):
            for filename in files:
                if filename[-7:] == '.schema':
                    b = filename[-15:]
                    barcode = b[:8]

                    fn = os.path.join(curdir, filename)
                    x = open(fn, 'r')
                    # fcntl.flock(x, fcntl.LOCK_EX)
                    parser = xml.sax.make_parser()
                    parser.setContentHandler(Handler(barcode))
                    parser.parse(x)
                    if not x.closed:
                        # fcntl.flock(x, fcntl.LOCK_UN)
                        x.close()
                    parser = None

    print('========')

    return

if __name__=="__main__":
    main()
